/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2960;
import net.minecraft.class_4231;
import org.embeddedt.modernfix.ModernFix;
import org.jetbrains.annotations.NotNull;

public class DynamicSoundHelpers {
    private static final long SOUND_EVICTION_DELAY = TimeUnit.SECONDS.toNanos(30L);
    private static final boolean debugDynamicSoundLoading = Boolean.getBoolean("modernfix.debugDynamicSoundLoading");

    public static final class Cache
    extends AbstractMap<class_2960, CompletableFuture<class_4231>> {
        private final Object2ObjectLinkedOpenHashMap<class_2960, Entry> store = new Object2ObjectLinkedOpenHashMap();

        public Cache(Map<class_2960, CompletableFuture<class_4231>> otherMap) {
            this.putAll(otherMap);
        }

        private void checkExpired() {
            Object2ObjectMap.Entry entry;
            long ts = System.nanoTime();
            ObjectBidirectionalIterator iter = this.store.object2ObjectEntrySet().fastIterator();
            while (iter.hasNext() && ((Entry)(entry = (Object2ObjectMap.Entry)iter.next()).getValue()).isExpired(ts)) {
                if (debugDynamicSoundLoading) {
                    ModernFix.LOGGER.warn("Evicted sound {} with duration {} ms", entry.getKey(), (Object)(((Entry)entry.getValue()).getDuration() / 1000000L));
                }
                ((Entry)entry.getValue()).discard();
                iter.remove();
            }
        }

        @Override
        public CompletableFuture<class_4231> get(Object key) {
            if (key instanceof class_2960) {
                class_2960 rl = (class_2960)key;
                Entry entry = (Entry)this.store.getAndMoveToLast((Object)rl);
                CompletableFuture<class_4231> result = entry != null ? entry.getBuffer() : null;
                this.checkExpired();
                return result;
            }
            return null;
        }

        @Override
        public CompletableFuture<class_4231> put(class_2960 key, CompletableFuture<class_4231> value) {
            Entry previousEntry;
            Entry entry = new Entry(value);
            if (debugDynamicSoundLoading) {
                ModernFix.LOGGER.info("Loaded sound {}", (Object)key);
            }
            return (previousEntry = (Entry)this.store.putAndMoveToLast((Object)key, (Object)entry)) != null ? previousEntry.getBuffer() : null;
        }

        @Override
        @NotNull
        public Set<Map.Entry<class_2960, CompletableFuture<class_4231>>> entrySet() {
            return new EntrySet();
        }

        private static class Entry {
            private final CompletableFuture<class_4231> buffer;
            private long lastAccessTime;

            private Entry(CompletableFuture<class_4231> buffer) {
                this.buffer = buffer;
                this.lastAccessTime = System.nanoTime();
            }

            public CompletableFuture<class_4231> getBuffer() {
                this.lastAccessTime = System.nanoTime();
                return this.buffer;
            }

            public long getDuration() {
                class_4231 buf = this.buffer.getNow(null);
                if (buf == null) {
                    return 0L;
                }
                return ((SoundBufAccess)buf).mfix$getDurationNanos();
            }

            public boolean isExpired(long currentTs) {
                long duration = this.getDuration();
                return duration > 0L && currentTs - this.lastAccessTime >= duration + SOUND_EVICTION_DELAY;
            }

            public void discard() {
                this.buffer.thenAccept(class_4231::method_19687);
            }

            public String toString() {
                return super.toString();
            }
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<class_2960, CompletableFuture<class_4231>>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<class_2960, CompletableFuture<class_4231>>> iterator() {
                final ObjectBidirectionalIterator storeIter = Cache.this.store.entrySet().iterator();
                return new Iterator<Map.Entry<class_2960, CompletableFuture<class_4231>>>(){

                    @Override
                    public boolean hasNext() {
                        return storeIter.hasNext();
                    }

                    @Override
                    public Map.Entry<class_2960, CompletableFuture<class_4231>> next() {
                        Map.Entry entry = (Map.Entry)storeIter.next();
                        return new AbstractMap.SimpleImmutableEntry<class_2960, CompletableFuture<class_4231>>((class_2960)entry.getKey(), ((Entry)entry.getValue()).buffer);
                    }
                };
            }

            @Override
            public int size() {
                return Cache.this.store.size();
            }

            @Override
            public void clear() {
                Cache.this.store.clear();
            }
        }
    }

    public static interface SoundBufAccess {
        public long mfix$getDurationNanos();
    }
}

